<div class="site-register">
    <div class="card-bg border border-custom rounded-lg mb-6">
        <div class="p-6">
            <h1 class="text-xl font-bold text-dark-custom mb-6">Регистрация</h1>

            <?php use yii\helpers\Html;
            use yii\widgets\ActiveForm;

            $form = ActiveForm::begin([
                'id' => 'register-form',
                'enableAjaxValidation' => true,
                'fieldConfig' => [
                    'template' => "{label}\n{input}\n{error}",
                    'labelOptions' => ['class' => 'block text-sm font-medium text-dark-custom mb-2'],
                    'inputOptions' => ['class' => 'w-full p-2 border border-custom rounded'],
                    'errorOptions' => ['class' => 'text-red-600 text-sm mt-1']
                ],
            ]); ?>

            <?= $form->errorSummary($model) ?>

            <div class="space-y-4">
                <?= $form->field($model, 'name')->textInput(['autofocus' => true]) ?>
                <?= $form->field($model, 'surname')->textInput() ?>
                <?= $form->field($model, 'patronymic')->textInput() ?>
                <?= $form->field($model, 'username')->textInput() ?>
                <?= $form->field($model, 'email')->textInput(['type' => 'email']) ?>
                <?= $form->field($model, 'password')->passwordInput() ?>
                <?= $form->field($model, 'password_repeat')->passwordInput() ?>

                <div class="flex items-center">
                    <?= $form->field($model, 'rules', [
                        'template' => '{input}'
                    ])->checkbox([
                        'class' => 'h-4 w-4 text-blue-600 border-custom rounded'
                    ]) ?>
                    <label for="registerform-rules" class="ml-2 block text-sm text-dark-custom">

                    </label>
                </div>

                <?= Html::submitButton('Зарегистрироваться', [
                    'class' => 'w-full bg-blue-600 hover:bg-blue-700 text-white font-medium py-2 px-4 rounded'
                ]) ?>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>