<?php
/** @var yii\web\View $this */
/** @var yii\bootstrap5\ActiveForm $form */
/** @var app\models\LoginForm $model */

use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;

?>
<div class="site-login">
    <div class="card-bg border border-custom rounded-lg mb-6">
        <div class="p-6">
            <h1 class="text-xl font-bold text-dark-custom mb-6">Войти</h1>

            <?php $form = ActiveForm::begin([
                'id' => 'login-form',
                'fieldConfig' => [
                    'template' => "{label}\n{input}\n{error}",
                    'labelOptions' => ['class' => 'block text-sm font-medium text-dark-custom mb-2'],
                    'inputOptions' => ['class' => 'w-full p-2 border border-custom rounded'],
                    'errorOptions' => ['class' => 'text-red-600 text-sm mt-1']
                ],
            ]); ?>

            <div class="space-y-4">
                <?= $form->field($model, 'login')->textInput([
                    'autofocus' => true,
                    'placeholder' => 'Логин или email'
                ])->label('Логин или Email') ?>

                <?= $form->field($model, 'password')->passwordInput(['placeholder' => 'Пароль']) ?>

                <div class="bg-blue-50 border border-blue-200 rounded p-3 text-sm text-blue-700 mb-4">
                    <div class="font-medium">Можно использовать:</div>
                    <div class="mt-1">• Логин: <span class="font-mono">vasya123</span></div>
                    <div>• Email: <span class="font-mono">vasya@example.com</span></div>
                </div>

                <?= Html::submitButton('Войти', [
                    'class' => 'w-full bg-blue-600 hover:bg-blue-700 text-white font-medium py-2 px-4 rounded'
                ]) ?>

                <div class="text-center mt-4">
                    <span class="text-sm text-gray-custom">Нет аккаунта? </span>
                    <?= Html::a('Зарегистрироваться', ['/site/register'], [
                        'class' => 'text-sm text-blue-600 hover:text-blue-700'
                    ]) ?>
                </div>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>