<?php

use app\models\Contests;
use yii\helpers\Url;
use yii\helpers\Html;
?>
<div class="site-index">
    <div class="card-bg border border-custom rounded-lg mb-8">
        <div class="p-8 text-center">
            <h1 class="text-2xl font-bold text-dark-custom mb-4">Творчество без границ</h1>
            <p class="text-gray-custom text-lg mb-6">
                Участвуй в творческих конкурсах, получай награды и достигай новых высот!
            </p>
            <?php if (Yii::$app->user->isGuest): ?>
                <div class="space-x-4">
                    <?= Html::a(
                        'Зарегистрироваться',
                        ['/site/register'],
                        ['class' => 'inline-block bg-blue-600 hover:bg-blue-700 text-white font-medium py-2 px-6 rounded']
                    ) ?>
                    <?= Html::a(
                        'Войти',
                        ['/site/login'],
                        ['class' => 'inline-block border border-blue-600 text-blue-600 hover:bg-blue-50 font-medium py-2 px-6 rounded']
                    ) ?>
                </div>
            <?php else: ?>
                <?php $user = Yii::$app->user->identity; ?>
                <?php if ($user->role === 'user' || $user->role === 'admin'): ?>
                    <?= Html::a(
                        'Подать заявку',
                        ['/application/create'],
                        ['class' => 'inline-block bg-blue-600 hover:bg-blue-700 text-white font-medium py-2 px-6 rounded']
                    ) ?>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>

    <h2 class="text-xl font-bold text-dark-custom mb-6">Активные конкурсы</h2>

    <?php
    $activeContests = Contests::find()
        ->where(['status' => 1])
        ->orderBy(['created_at' => SORT_DESC])
        ->all();
    ?>

    <?php if (empty($activeContests)): ?>
        <div class="card-bg border border-custom rounded-lg p-6 text-center">
            <p class="text-gray-custom">В данный момент нет активных конкурсов.</p>
        </div>
    <?php else: ?>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php foreach ($activeContests as $contest): ?>
                <div class="card-bg border border-custom rounded-lg overflow-hidden hover:shadow-lg transition-shadow duration-300">
                    <?php if ($contest->image_path): ?>
                        <img src="<?= Url::to($contest->image_path) ?>"
                             alt="<?= Html::encode($contest->name) ?>"
                             class="w-full h-48 object-cover">
                    <?php else: ?>
                        <div class="w-full h-48 bg-gradient-to-r from-blue-100 to-purple-100 flex items-center justify-center">
                            <div class="text-center">
                                <svg class="w-16 h-16 text-gray-400 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                </svg>
                                <span class="text-gray-500 text-sm mt-2">Конкурс</span>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="p-6">
                        <h3 class="font-bold text-dark-custom text-lg mb-3"><?= Html::encode($contest->name) ?></h3>

                        <p class="text-gray-custom text-sm mb-4">
                            <?= mb_substr(Html::encode($contest->description), 0, 60) ?>
                            <?= mb_strlen($contest->description) > 60 ? '...' : '' ?>
                        </p>

                        <div class="text-xs text-gray-500 mb-4">
                            <div class="flex items-center">
                                <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z" clip-rule="evenodd"/>
                                </svg>
                                <?= date('d.m.Y', strtotime($contest->start_date)) ?> - <?= date('d.m.Y', strtotime($contest->end_date)) ?>
                            </div>
                        </div>

                        <div class="flex justify-between items-center">
                            <a href="<?= Url::to(['contest/view', 'id' => $contest->id]) ?>"
                               class="inline-block text-blue-600 hover:text-blue-700 font-medium">
                                Подробнее →
                            </a>

                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <?php
    $archivedContests = Contests::find()
        ->where(['status' => 0])
        ->orderBy(['created_at' => SORT_DESC])
        ->limit(3)
        ->all();
    ?>

    <?php if (!empty($archivedContests)): ?>
        <div class="mt-12">
            <h2 class="text-xl font-bold text-dark-custom mb-6">Прошедшие конкурсы</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <?php foreach ($archivedContests as $contest): ?>
                    <div class="card-bg border border-custom rounded-lg overflow-hidden opacity-75">
                        <div class="p-6">
                            <h3 class="font-bold text-dark-custom text-lg mb-3"><?= Html::encode($contest->name) ?></h3>
                            <p class="text-gray-custom text-sm mb-4">
                                <?= mb_substr(Html::encode($contest->description), 0, 60) ?>...
                            </p>
                            <div class="text-xs text-gray-500">
                                Завершен <?= date('d.m.Y', strtotime($contest->end_date)) ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>
</div>