<?php
/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\widgets\Alert;
use yii\bootstrap5\Html;
use yii\helpers\Url;

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1']);
?>
<?php $this->beginPage() ?>
    <!DOCTYPE html>
    <html lang="<?= Yii::$app->language ?>" class="h-full">
    <head>
        <title><?= Html::encode($this->title) ?></title>
        <script src="https://cdn.tailwindcss.com"></script>
        <link href="https://fonts.googleapis.com/css2?family=Ubuntu:wght@300;400;500;700&display=swap" rel="stylesheet">
        <style>
            body { font-family: 'Ubuntu', sans-serif; background-color: #FFFFFF; }
            .sidebar-bg { background-color: #F8FAFC; }
            .border-custom { border-color: #D1D4D9; }
            .card-bg { background-color: #F8FAFC; }
            .text-gray-custom { color: #6B7280; }
            .text-dark-custom { color: #1F2937; }
        </style>
        <?php $this->head() ?>
    </head>
    <body class="h-full">
    <?php $this->beginBody() ?>

    <div class="flex h-screen">
        <div class="sidebar-bg border-r border-custom w-64 flex flex-col ml-5">
            <div class="p-6 border-b border-custom">
                <div class="text-xl font-bold text-dark-custom">
                    Конкурсная<br>
                    платформа
                </div>
            </div>

            <div class="p-6 space-y-4 flex-1">
                <div>
                    <?= Html::a(
                        'Главная',
                        ['/site/index'],
                        ['class' => 'block text-dark-custom hover:text-blue-600']
                    ) ?>
                </div>
                <div>
                    <?= Html::a(
                        'О нас',
                        ['/site/about'],
                        ['class' => 'block text-dark-custom hover:text-blue-600']
                    ) ?>
                </div>

                <?php if (!Yii::$app->user->isGuest): ?>
                    <?php $user = Yii::$app->user->identity; ?>

                    <?php if ($user->role === 'user' || $user->role === 'admin'): ?>
                        <div>
                            <?= Html::a(
                                'Личный кабинет',
                                ['/cabinet/index'],
                                ['class' => 'block text-dark-custom hover:text-blue-600']
                            ) ?>
                        </div>
                        <div>
                            <?= Html::a(
                                'Мои заявки',
                                ['/cabinet/applications'],
                                ['class' => 'block text-dark-custom hover:text-blue-600']
                            ) ?>
                        </div>
                    <?php endif; ?>

                    <?php if ($user->role === 'expert' || $user->role === 'admin'): ?>
                        <div>
                            <?= Html::a(
                                'Панель эксперта',
                                ['/expert/index'],
                                ['class' => 'block text-dark-custom hover:text-blue-600']
                            ) ?>
                        </div>
                    <?php endif; ?>

                    <?php if ($user->role === 'admin'): ?>
                        <div>
                            <?= Html::a(
                                'Панель-администратора',
                                ['/admin/index'],
                                ['class' => 'block text-dark-custom hover:text-blue-600']
                            ) ?>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>

                <div>
                    <?= Html::a(
                        'Контакты',
                        ['/site/contact'],
                        ['class' => 'block text-dark-custom hover:text-blue-600']
                    ) ?>
                </div>
            </div>
        </div>

        <div class="flex-1 flex flex-col overflow-hidden">
            <div class="sidebar-bg border border-custom p-6 mx-5">
                <div class="flex justify-between items-center">
                    <div class="text-lg font-medium text-dark-custom">
                        <?php if (!Yii::$app->user->isGuest): ?>
                            Приветствуем вас, <?= Html::encode(Yii::$app->user->identity->username) ?>!
                        <?php else: ?>
                            Добро пожаловать на конкурсную платформу
                        <?php endif; ?>
                    </div>
                    <div class="text-gray-custom">
                        <?php if (!Yii::$app->user->isGuest): ?>
                            <?php
                            $unreadCount = Yii::$app->user->identity->getUnreadNotificationsCount();
                            ?>

                            <a href="<?= Url::to(['/cabinet/notifications']) ?>"
                               class="relative inline-flex items-center px-3 py-2 rounded-md text-sm font-medium text-gray-700 hover:text-gray-900 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                <svg class="mr-2 h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                                </svg>
                                Уведомления
                                <?php if ($unreadCount > 0): ?>
                                    <span class="ml-2 notification-count inline-flex items-center justify-center px-2 py-1 text-xs font-bold leading-none text-white bg-red-600 rounded-full">
                <?= $unreadCount ?>
            </span>
                                <?php else: ?>
                                    <span class="ml-2 notification-count hidden"></span>
                                <?php endif; ?>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <main class="card-bg border border-custom flex-1 overflow-y-auto m-5 p-6">
                <?= Alert::widget() ?>
                <?= $content ?>
            </main>
        </div>
    </div>

    <?php $this->endBody() ?>
    </body>
    </html>
<?php $this->endPage() ?>