<?php
use yii\helpers\Html;
use yii\helpers\Url;
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Админ панель</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
<div class="flex">
    <!-- Сайдбар -->
    <div class="w-64 bg-gray-800 text-white min-h-screen p-4">
        <h1 class="text-xl font-bold mb-6">Админ панель</h1>
        <nav class="space-y-2">
            <a href="<?= Url::to(['admin/index']) ?>" class="block py-2 px-4 hover:bg-gray-700 rounded">Главная</a>
            <a href="<?= Url::to(['admin/contests']) ?>" class="block py-2 px-4 hover:bg-gray-700 rounded">Конкурсы</a>
            <a href="<?= Url::to(['admin/categories']) ?>" class="block py-2 px-4 hover:bg-gray-700 rounded">Категории</a>
            <a href="<?= Url::to(['admin/applications']) ?>" class="block py-2 px-4 hover:bg-gray-700 rounded">Заявки</a>
            <a href="<?= Url::to(['admin/users']) ?>" class="block py-2 px-4 hover:bg-gray-700 rounded">Пользователи</a>
            <a href="<?= Url::to(['admin/experts']) ?>" class="block py-2 px-4 hover:bg-gray-700 rounded">Эксперты</a>
            <a href="<?= Url::to(['admin/notifications']) ?>" class="block py-2 px-4 hover:bg-gray-700 rounded">Уведомления</a>
            <a href="<?= Url::to(['site/logout']) ?>" class="block py-2 px-4 hover:bg-red-600 rounded mt-10">Выйти</a>
        </nav>
    </div>

    <!-- Контент -->
    <div class="flex-1 p-6">
        <?php if (Yii::$app->session->hasFlash('success')): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                <?= Yii::$app->session->getFlash('success') ?>
            </div>
        <?php endif; ?>

        <?php if (Yii::$app->session->hasFlash('error')): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                <?= Yii::$app->session->getFlash('error') ?>
            </div>
        <?php endif; ?>

        <?= $content ?>
    </div>
</div>
</body>
</html>