<?php
// views/expert/rate.php
use yii\helpers\Html;

$this->title = 'Оценка заявки';
?>
<div class="expert-rate">
    <div class="card-bg border border-custom rounded-lg mb-6">
        <div class="p-6">
            <h1 class="text-xl font-bold text-dark-custom mb-6">Оценка работы</h1>
            <div class="mb-6 p-4 bg-gray-50 border border-custom rounded">
                <h3 class="font-bold mb-2"><?= Html::encode($application->work_name) ?></h3>
                <p class="text-sm text-gray-custom">
                    Участник: <?= Html::encode($application->user->name) ?> <?= Html::encode($application->user->surname) ?><br>
                    Конкурс: <?= Html::encode($application->contest->name) ?><br>
                    Номинация: <?= Html::encode($application->nomination->name) ?>
                </p>
            </div>

            <form method="post">
                <input type="hidden" name="<?= Yii::$app->request->csrfParam ?>" value="<?= Yii::$app->request->csrfToken ?>">

                <div class="space-y-4 mb-6">
                    <div>
                        <label class="block text-sm font-medium text-dark-custom mb-2">Мастерство (0-100)</label>
                        <input type="number" name="mastery" value="<?= $rating->mastery ?? 0 ?>"
                               min="0" max="100" class="w-full p-2 border border-custom rounded">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-dark-custom mb-2">Артистизм (0-100)</label>
                        <input type="number" name="artistry" value="<?= $rating->artistry ?? 0 ?>"
                               min="0" max="100" class="w-full p-2 border border-custom rounded">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-dark-custom mb-2">Сценическая культура (0-100)</label>
                        <input type="number" name="stage_culture" value="<?= $rating->stage_culture ?? 0 ?>"
                               min="0" max="100" class="w-full p-2 border border-custom rounded">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-dark-custom mb-2">Комментарий</label>
                        <textarea name="comment" rows="4" class="w-full p-2 border border-custom rounded"><?= $rating->comment ?? '' ?></textarea>
                    </div>
                </div>

                <div class="mb-6 p-4 bg-blue-50 border border-custom rounded">
                    <div class="flex justify-between">
                        <span class="font-medium">Общий балл:</span>
                        <span id="total-score" class="font-bold text-blue-600">0</span>
                    </div>
                </div>

                <div class="flex space-x-4">
                    <button type="submit" name="save_draft"
                            class="px-4 py-2 bg-gray-600 text-white rounded hover:bg-gray-700">
                        Сохранить черновик
                    </button>

                    <button type="submit" name="complete"
                            class="px-4 py-2 bg-green-600 text-white rounded hover:bg-green-700">
                        Завершить оценку
                    </button>

                    <?= Html::a('Отмена', ['index'], [
                        'class' => 'px-4 py-2 border border-custom text-dark-custom rounded hover:bg-gray-50'
                    ]) ?>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    document.querySelectorAll('input[type="number"]').forEach(input => {
        input.addEventListener('input', updateTotal);
    });

    function updateTotal() {
        let mastery = parseInt(document.querySelector('[name="mastery"]').value) || 0;
        let artistry = parseInt(document.querySelector('[name="artistry"]').value) || 0;
        let stage = parseInt(document.querySelector('[name="stage_culture"]').value) || 0;

        let total = mastery + artistry + stage;
        document.getElementById('total-score').textContent = total;
    }

    // Инициализация
    updateTotal();
</script>