<?php
// views/expert/index.php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Панель эксперта';
?>
<div class="expert-index">
    <div class="card-bg border border-custom rounded-lg mb-6">
        <div class="p-6">
            <h1 class="text-xl font-bold text-dark-custom mb-6">Заявки для оценки</h1>

            <?php if (empty($applications)): ?>
                <div class="text-center py-8">
                    <div class="text-gray-custom mb-2">Нет заявок для оценки.</div>
                </div>
            <?php else: ?>
                <div class="space-y-4">
                    <?php foreach ($applications as $app): ?>
                        <div class="card-bg border border-custom rounded-lg p-4 hover:bg-gray-50">
                            <div class="flex justify-between items-center">
                                <div>
                                    <h3 class="font-medium text-dark-custom"><?= Html::encode($app->work_name) ?></h3>
                                    <p class="text-sm text-gray-custom">
                                        <?= Html::encode($app->contest->name) ?> •
                                        <?= Html::encode($app->nomination->name) ?>
                                    </p>
                                    <p class="text-sm text-gray-custom">
                                        Участник: <?= Html::encode($app->user->name) ?> <?= Html::encode($app->user->surname) ?>
                                    </p>
                                </div>
                                <div>
                                    <?= Html::a('Оценить', ['rate', 'id' => $app->id], [
                                        'class' => 'px-4 py-2 bg-green-600 text-white rounded hover:bg-green-700'
                                    ]) ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <div class="mt-6 pt-6 border-t border-custom">
                <?= Html::a('Завершенные оценки', ['completed'], [
                    'class' => 'text-blue-600 hover:text-blue-700'
                ]) ?>
            </div>
        </div>
    </div>
</div>