<?php
use yii\helpers\Html;

$this->title = 'Завершенные оценки';
?>
<div class="expert-completed">
    <div class="card-bg border border-custom rounded-lg mb-6">
        <div class="p-6">
            <h1 class="text-xl font-bold text-dark-custom mb-6">Завершенные оценки</h1>

            <?php if (empty($ratings)): ?>
                <div class="text-center py-8">
                    <div class="text-gray-custom mb-2">Нет завершенных оценок.</div>
                </div>
            <?php else: ?>
                <div class="space-y-4">
                    <?php foreach ($ratings as $rating): ?>
                        <div class="card-bg border border-custom rounded-lg p-4">
                            <h3 class="font-medium text-dark-custom mb-2">
                                <?= Html::encode($rating->application->work_name) ?>
                            </h3>
                            <p class="text-sm text-gray-custom mb-3">
                                Конкурс: <?= Html::encode($rating->application->contest->name) ?>
                            </p>
                            <div class="flex justify-between text-sm">
                                <div>
                                    <div class="text-gray-custom">Баллы:</div>
                                    <div class="font-medium">
                                        Мастерство: <?= $rating->mastery ?><br>
                                        Артистизм: <?= $rating->artistry ?><br>
                                        Сценическая культура: <?= $rating->stage_culture ?>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <div class="text-gray-custom">Общий балл:</div>
                                    <div class="text-2xl font-bold text-blue-600">
                                        <?= $rating->total_score ?>
                                    </div>
                                    <div class="text-xs text-gray-custom">
                                        из 300
                                    </div>
                                </div>
                            </div>
                            <?php if ($rating->comment): ?>
                                <div class="mt-3 pt-3 border-t border-custom">
                                    <div class="text-gray-custom text-sm">Комментарий:</div>
                                    <div class="text-sm"><?= Html::encode($rating->comment) ?></div>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <div class="mt-6 pt-6 border-t border-custom">
                <?= Html::a('← Назад к оценке заявок', ['index'], [
                    'class' => 'text-blue-600 hover:text-blue-700'
                ]) ?>
            </div>
        </div>
    </div>
</div>