<?php
use yii\helpers\Html;
use yii\helpers\Url;

?>
<div class="contest-view">
    <div class="card-bg border border-custom mb-6">
        <div class="p-6">
            <h1 class="text-xl font-bold text-dark-custom mb-4"><?= Html::encode($contest->name) ?></h1>

            <div class="space-y-4">
                <div>
                    <div class="font-medium text-dark-custom mb-1">Описание:</div>
                    <div class="text-gray-custom bg-gray-50 border border-custom rounded p-4">
                        <?= Html::encode($contest->description) ?>
                    </div>
                </div>

                <div class="flex space-x-8">
                    <div>
                        <div class="font-medium text-dark-custom">Начало:</div>
                        <div class="text-gray-custom"><?= Yii::$app->formatter->asDate($contest->start_date) ?></div>
                    </div>
                    <div>
                        <div class="font-medium text-dark-custom">Окончание:</div>
                        <div class="text-gray-custom"><?= Yii::$app->formatter->asDate($contest->end_date) ?></div>
                    </div>
                </div>

                <div class="pt-4 border-t border-custom">
                    <?php if (!Yii::$app->user->isGuest): ?>
                        <a href="<?= Url::to(['/cabinet/apply', 'contest_id' => $contest->id]) ?>"
                           class="inline-block bg-green-600 hover:bg-green-700 text-white font-medium py-2 px-6 rounded">
                            Подать заявку
                        </a>
                    <?php else: ?>
                        <div class="text-gray-custom">
                            Для подачи заявки необходимо авторизоваться.
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>