<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\Pjax;

/* @var $this yii\web\View */
/* @var $notifications app\models\Notification[] */

$this->title = 'Мои уведомления';
?>
    <div class="cabinet-notifications">
        <div class="card-bg border border-custom rounded-lg mb-6">
            <div class="p-6">
                <div class="flex justify-between items-center mb-6">
                    <h1 class="text-xl font-bold text-dark-custom">Уведомления</h1>

                    <?php if (count($notifications) > 0): ?>
                        <?= Html::a(
                            'Отметить все как прочитанные',
                            ['/cabinet/mark-all-as-read'],
                            [
                                'class' => 'px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded transition duration-150',
                                'data' => [
                                    'confirm' => 'Вы уверены, что хотите отметить все уведомления как прочитанные?',
                                    'method' => 'post',
                                ]
                            ]
                        ) ?>
                    <?php endif; ?>
                </div>

                <?php Pjax::begin(['id' => 'notifications-pjax']); ?>

                <?php if (empty($notifications)): ?>
                    <div class="text-center py-8">
                        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                        </svg>
                        <div class="text-gray-custom mt-2">У вас пока нет уведомлений.</div>
                    </div>
                <?php else: ?>
                    <div class="space-y-3">
                        <?php foreach ($notifications as $notification): ?>
                            <div class="card-bg border border-custom rounded-lg p-4 hover:bg-gray-50 transition duration-150 <?= $notification->is_read == 0 ? 'bg-blue-50 border-blue-200' : '' ?>">
                                <div class="flex items-start justify-between">
                                    <div class="flex-1">
                                        <div class="flex items-center space-x-2 mb-1">
                                            <?php if ($notification->is_read == 0): ?>
                                                <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium bg-blue-600 text-white">
                                                Новое
                                            </span>
                                            <?php else: ?>
                                                <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium bg-gray-200 text-gray-700">
                                                Прочитано
                                            </span>
                                            <?php endif; ?>
                                        </div>

                                        <h3 class="font-medium text-dark-custom text-base"><?= Html::encode($notification->title) ?></h3>
                                        <p class="text-gray-custom text-sm mt-1"><?= Html::encode($notification->message) ?></p>

                                        <div class="flex items-center text-xs text-gray-500 mt-2">
                                            <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd" />
                                            </svg>
                                            <?= Yii::$app->formatter->asRelativeTime($notification->created_at) ?>
                                        </div>
                                    </div>

                                    <div class="ml-4 flex-shrink-0">
                                        <?php if ($notification->is_read == 0): ?>
                                            <?= Html::a(
                                                'Прочитано',
                                                ['/cabinet/mark-as-read', 'id' => $notification->id],
                                                [
                                                    'class' => 'inline-flex items-center px-3 py-1.5 border border-transparent text-xs font-medium rounded text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-150',
                                                    'data' => [
                                                        'method' => 'post',
                                                        'pjax' => 1,
                                                    ]
                                                ]
                                            ) ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>

                    <?php if ($pagination->totalCount > $pagination->pageSize): ?>
                        <div class="mt-6 flex items-center justify-between border-t border-custom pt-4">
                            <div class="flex-1 flex justify-between sm:hidden">
                                <?= Html::a(
                                    'Назад',
                                    ['/cabinet/notifications', 'page' => max(1, $pagination->page) - 1],
                                    ['class' => 'relative inline-flex items-center px-4 py-2 border border-custom text-sm font-medium rounded-md text-dark-custom bg-white hover:bg-gray-50' . ($pagination->page == 0 ? ' opacity-50 cursor-not-allowed' : '')]
                                ) ?>
                                <?= Html::a(
                                    'Вперед',
                                    ['/cabinet/notifications', 'page' => min($pagination->pageCount - 1, $pagination->page) + 1],
                                    ['class' => 'ml-3 relative inline-flex items-center px-4 py-2 border border-custom text-sm font-medium rounded-md text-dark-custom bg-white hover:bg-gray-50' . ($pagination->page == $pagination->pageCount - 1 ? ' opacity-50 cursor-not-allowed' : '')]
                                ) ?>
                            </div>
                            <div class="hidden sm:flex-1 sm:flex sm:items-center sm:justify-between">
                                <div>
                                    <p class="text-sm text-gray-custom">
                                        Показано
                                        <span class="font-medium"><?= ($pagination->page * $pagination->pageSize) + 1 ?></span>
                                        -
                                        <span class="font-medium"><?= min(($pagination->page + 1) * $pagination->pageSize, $pagination->totalCount) ?></span>
                                        из
                                        <span class="font-medium"><?= $pagination->totalCount ?></span>
                                        уведомлений
                                    </p>
                                </div>
                                <div>
                                    <nav class="relative z-0 inline-flex rounded-md shadow-sm -space-x-px" aria-label="Pagination">
                                        <?php if ($pagination->page > 0): ?>
                                            <?= Html::a(
                                                '<svg class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M12.707 5.293a1 1 0 010 1.414L9.414 10l3.293 3.293a1 1 0 01-1.414 1.414l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 0z" clip-rule="evenodd" /></svg>',
                                                ['/cabinet/notifications', 'page' => $pagination->page - 1],
                                                [
                                                    'class' => 'relative inline-flex items-center px-2 py-2 rounded-l-md border border-custom bg-white text-sm font-medium text-gray-500 hover:bg-gray-50',
                                                    'aria-label' => 'Previous',
                                                    'data-pjax' => 1
                                                ]
                                            ) ?>
                                        <?php endif; ?>

                                        <?php for ($i = 0; $i < $pagination->pageCount; $i++): ?>
                                            <?php if ($i == $pagination->page): ?>
                                                <span class="relative inline-flex items-center px-4 py-2 border border-blue-500 bg-blue-50 text-sm font-medium text-blue-600">
                                                <?= $i + 1 ?>
                                            </span>
                                            <?php else: ?>
                                                <?= Html::a(
                                                    $i + 1,
                                                    ['/cabinet/notifications', 'page' => $i],
                                                    [
                                                        'class' => 'relative inline-flex items-center px-4 py-2 border border-custom bg-white text-sm font-medium text-gray-700 hover:bg-gray-50',
                                                        'data-pjax' => 1
                                                    ]
                                                ) ?>
                                            <?php endif; ?>
                                        <?php endfor; ?>

                                        <?php if ($pagination->page < $pagination->pageCount - 1): ?>
                                            <?= Html::a(
                                                '<svg class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd" /></svg>',
                                                ['/cabinet/notifications', 'page' => $pagination->page + 1],
                                                [
                                                    'class' => 'relative inline-flex items-center px-2 py-2 rounded-r-md border border-custom bg-white text-sm font-medium text-gray-500 hover:bg-gray-50',
                                                    'aria-label' => 'Next',
                                                    'data-pjax' => 1
                                                ]
                                            ) ?>
                                        <?php endif; ?>
                                    </nav>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>

                <?php Pjax::end(); ?>
            </div>
        </div>
    </div>

<?php
$this->registerJs(<<<JS
setInterval(function() {
    $.ajax({
        url: 'get-unread-count',
        type: 'GET',
        success: function(data) {
            if (data.count > 0) {
                $('.notification-count').text(data.count).removeClass('hidden');
            } else {
                $('.notification-count').addClass('hidden');
            }
        }
    });
}, 30000);
JS);
?>