<?php
use yii\helpers\Html;
?>
<div class="cabinet-index">
    <div class="card-bg border border-custom mb-6">
        <div class="p-6">
            <h1 class="text-xl font-bold text-dark-custom mb-6">Личный кабинет</h1>

            <div class="mb-6">
                <h2 class="font-medium text-dark-custom mb-4">Информация о пользователе</h2>

                <div class="space-y-3">
                    <div class="flex">
                        <div class="w-32 text-gray-custom">ФИО:</div>
                        <div class="font-medium"><?= Html::encode($user->getFullName()) ?></div>
                    </div>
                    <div class="flex">
                        <div class="w-32 text-gray-custom">Логин:</div>
                        <div class="font-medium"><?= Html::encode($user->username) ?></div>
                    </div>
                    <div class="flex">
                        <div class="w-32 text-gray-custom">Email:</div>
                        <div class="font-medium"><?= Html::encode($user->email) ?></div>
                    </div>
                </div>
            </div>
<!--издец-->
            <div class="space-y-3">
                <?= Html::a(
                    'Редактировать профиль',
                    ['/cabinet/profile'],
                    ['class' => 'block w-full text-left bg-green-600 text-white font-medium py-2 px-4 rounded cursor-pointer']
                ) ?>
                <?= Html::a(
                    'Изменить пароль',
                    ['/cabinet/change-password'],
                    ['class' => 'block w-full text-left bg-blue-600 text-white font-medium py-2 px-4 rounded cursor-pointer']
                ) ?>
                <?= Html::a(
                    'Мои заявки',
                    ['/cabinet/applications'],
                    ['class' => 'block w-full text-left bg-gray-600 text-white font-medium py-2 px-4 rounded cursor-pointer']
                ) ?>
            </div>
        </div>
    </div>
</div>