<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;


?>
<div class="cabinet-change-password">
    <div class="card-bg border border-custom rounded-lg mb-6">
        <div class="p-6">
            <h1 class="text-xl font-bold text-dark-custom mb-6">Смена пароля</h1>

            <?php $form = ActiveForm::begin([
                'fieldConfig' => [
                    'template' => "{label}\n{input}\n{error}",
                    'labelOptions' => ['class' => 'block text-sm font-medium text-dark-custom mb-2'],
                    'inputOptions' => ['class' => 'w-full p-2 border border-custom rounded'],
                    'errorOptions' => ['class' => 'text-red-600 text-sm mt-1']
                ],
            ]); ?>

            <div class="space-y-4">
                <?= $form->field($model, 'currentPassword')->passwordInput() ?>
                <?= $form->field($model, 'newPassword')->passwordInput() ?>
                <?= $form->field($model, 'newPasswordRepeat')->passwordInput() ?>

                <div class="flex space-x-4 pt-6 border-t border-custom">
                    <a href="/cabinet/index" class="px-6 py-2 border border-custom text-dark-custom rounded hover:bg-gray-50">
                        Отмена
                    </a>
                    <?= Html::submitButton('Сменить пароль', [
                        'class' => 'px-6 py-2 bg-green-600 text-white rounded hover:bg-green-700'
                    ]) ?>
                </div>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>