<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
?>
<div class="cabinet-apply">
    <div class="card-bg border border-custom rounded-lg mb-6">
        <div class="p-6">
            <h1 class="text-xl font-bold text-dark-custom mb-6">Подача заявки на конкурс: <?= Html::encode($contest->name) ?></h1>

            <?php $form = ActiveForm::begin([
                'options' => [
                    'enctype' => 'multipart/form-data',
                    'class' => 'space-y-6'
                ]
            ]) ?>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-dark-custom mb-2">Номинация</label>
                    <?= $form->field($model, 'nomination_id', [
                        'template' => '{input}{error}'
                    ])->dropDownList(
                        \yii\helpers\ArrayHelper::map($nominations, 'id', 'name'),
                        [
                            'prompt' => 'Выберите номинацию',
                            'class' => 'w-full p-2 border border-custom rounded'
                        ]
                    )->label(false) ?>
                </div>

                <div>
                    <label class="block text-sm font-medium text-dark-custom mb-2">Возрастная категория</label>
                    <?= $form->field($model, 'age_category_id', [
                        'template' => '{input}{error}'
                    ])->dropDownList(
                        \yii\helpers\ArrayHelper::map($ageCategories, 'id', 'name'),
                        [
                            'prompt' => 'Выберите возрастную категорию',
                            'class' => 'w-full p-2 border border-custom rounded'
                        ]
                    )->label(false) ?>
                </div>
            </div>

            <div>
                <label class="block text-sm font-medium text-dark-custom mb-2">Название работы</label>
                <?= $form->field($model, 'work_name', [
                    'template' => '{input}{error}'
                ])->textInput([
                    'maxlength' => true,
                    'class' => 'w-full p-2 border border-custom rounded',
                    'placeholder' => ''
                ])->label(false) ?>
            </div>

            <div>
                <label class="block text-sm font-medium text-dark-custom mb-2">Файл работы</label>
                <?= $form->field($model, 'file', [
                    'template' => '{input}{error}'
                ])->fileInput([
                    'class' => 'w-full p-2 border border-custom rounded'
                ])->label(false) ?>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-dark-custom mb-2">Учреждение</label>
                    <?= $form->field($model, 'institution', [
                        'template' => '{input}{error}'
                    ])->textInput([
                        'maxlength' => true,
                        'class' => 'w-full p-2 border border-custom rounded',
                        'placeholder' => ''
                    ])->label(false) ?>
                </div>

                <div>
                    <label class="block text-sm font-medium text-dark-custom mb-2">Руководитель</label>
                    <?= $form->field($model, 'leader', [
                        'template' => '{input}{error}'
                    ])->textInput([
                        'maxlength' => true,
                        'class' => 'w-full p-2 border border-custom rounded',
                        'placeholder' => ''
                    ])->label(false) ?>
                </div>
            </div>

            <div class="flex space-x-4 pt-6 border-t border-custom">
                <?= Html::a(
                    'Отмена',
                    ['/contest/view', 'id' => $contest->id],
                    ['class' => 'px-6 py-2 border border-custom text-dark-custom rounded hover:bg-gray-50']
                ) ?>

                <?= Html::submitButton('Отправить заявку', [
                    'class' => 'px-6 py-2 bg-green-600 text-white rounded hover:bg-green-700'
                ]) ?>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>