<?php
use yii\helpers\Html;
use yii\helpers\Url;
?>
<div class="cabinet-applications">
    <div class="card-bg border border-custom mb-6">
        <div class="p-6">
            <h1 class="text-xl font-bold text-dark-custom mb-6">Мои заявки</h1>

            <?php if (empty($applications)): ?>
                <div class="text-center py-8">
                    <div class="text-gray-custom mb-2">У вас пока нет заявок.</div>
                </div>
            <?php else: ?>
                <div class="border border-custom rounded-lg overflow-hidden">
                    <table class="min-w-full divide-y divide-custom">
                        <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-3 text-left text-sm font-medium text-dark-custom border-r border-custom">Конкурс</th>
                            <th class="px-4 py-3 text-left text-sm font-medium text-dark-custom border-r border-custom">Номинация</th>
                            <th class="px-4 py-3 text-left text-sm font-medium text-dark-custom border-r border-custom">Возрастная категория</th>
                            <th class="px-4 py-3 text-left text-sm font-medium text-dark-custom border-r border-custom">Название работы</th>
                            <th class="px-4 py-3 text-left text-sm font-medium text-dark-custom border-r border-custom">Статус</th>
                            <th class="px-4 py-3 text-left text-sm font-medium text-dark-custom">Действия</th>
                        </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-custom">
                        <?php foreach ($applications as $app): ?>
                            <tr class="hover:bg-gray-50">
                                <td class="px-4 py-3 text-sm text-dark-custom border-r border-custom"><?= Html::encode($app->contest->name) ?></td>
                                <td class="px-4 py-3 text-sm text-dark-custom border-r border-custom"><?= Html::encode($app->nomination->name) ?></td>
                                <td class="px-4 py-3 text-sm text-dark-custom border-r border-custom"><?= Html::encode($app->ageCategory->name) ?></td>
                                <td class="px-4 py-3 text-sm text-dark-custom border-r border-custom"><?= Html::encode($app->work_name) ?></td>
                                <td class="px-4 py-3 border-r border-custom">
                                    <?php
                                    $statusColors = [
                                        'new' => 'bg-blue-100 text-blue-800',
                                        'approved' => 'bg-green-100 text-green-800',
                                        'rejected' => 'bg-red-100 text-red-800',
                                        'blocked' => 'bg-gray-100 text-gray-800'
                                    ];
                                    $color = $statusColors[$app->status] ?? 'bg-gray-100 text-gray-800';
                                    ?>
                                    <span class="text-xs font-medium px-2 py-1 rounded <?= $color ?>">
                                            <?= $app->status ?>
                                        </span>
                                </td>
                                <td class="px-4 py-3">
                                    <?= Html::a(
                                        'Просмотр',
                                        ['/cabinet/application-view', 'id' => $app->id],
                                        ['class' => 'text-blue-600 hover:text-blue-700 mr-3']
                                    ) ?>

                                    <?php if ($app->status == 'new'): ?>
                                        <?= Html::a(
                                            'Отменить',
                                            ['/cabinet/application-cancel', 'id' => $app->id],
                                            [
                                                'class' => 'text-red-600 hover:text-red-700',
                                                'data' => [
                                                    'confirm' => 'Вы уверены, что хотите отменить заявку?',
                                                    'method' => 'post',
                                                ]
                                            ]
                                        ) ?>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>