<?php

use yii\helpers\Html;

?>
<div class="cabinet-application-view">
    <div class="card-bg border border-custom rounded-lg mb-6">
        <div class="p-6">
            <h1 class="text-xl font-bold text-dark-custom mb-6">Просмотр заявки</h1>

            <div class="space-y-4">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <div class="text-sm text-gray-custom">Конкурс:</div>
                        <div class="font-medium"><?= Html::encode($application->contest->name) ?></div>
                    </div>
                    <div>
                        <div class="text-sm text-gray-custom">Номинация:</div>
                        <div class="font-medium"><?= Html::encode($application->nomination->name) ?></div>
                    </div>
                    <div>
                        <div class="text-sm text-gray-custom">Возрастная категория:</div>
                        <div class="font-medium"><?= Html::encode($application->ageCategory->name) ?></div>
                    </div>
                    <div>
                        <div class="text-sm text-gray-custom">Статус:</div>
                        <div>
                            <?php
                            $statusColors = [
                                'new' => 'bg-blue-100 text-blue-800',
                                'approved' => 'bg-green-100 text-green-800',
                                'rejected' => 'bg-red-100 text-red-800',
                                'blocked' => 'bg-gray-100 text-gray-800'
                            ];
                            $color = $statusColors[$application->status] ?? 'bg-gray-100 text-gray-800';
                            ?>
                            <span class="text-xs font-medium px-2 py-1 rounded <?= $color ?>">
                                <?= $application->status ?>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="border-t border-custom pt-4">
                    <div class="text-sm text-gray-custom mb-1">Название работы:</div>
                    <div class="font-medium"><?= Html::encode($application->work_name) ?></div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <div class="text-sm text-gray-custom">Учреждение:</div>
                        <div class="font-medium"><?= Html::encode($application->institution) ?></div>
                    </div>
                    <div>
                        <div class="text-sm text-gray-custom">Руководитель:</div>
                        <div class="font-medium"><?= Html::encode($application->leader) ?></div>
                    </div>
                </div>

                <div class="border-t border-custom pt-4">
                    <div class="text-sm text-gray-custom mb-1">Файл:</div>
                    <?php if ($application->file_path): ?>
                        <a href="/<?= $application->file_path ?>" class="text-blue-600 hover:text-blue-700">
                            Скачать файл
                        </a>
                    <?php else: ?>
                        <div class="text-gray-custom">Файл не загружен</div>
                    <?php endif; ?>
                </div>
                
            </div>
        </div>
    </div>
</div>