<?php
use yii\helpers\Url;
?>
<div class="p-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">Пользователи</h1>
        <a href="<?= Url::to(['user-create']) ?>" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
            + Создать пользователя
        </a>
    </div>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ФИО</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Логин/Email</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Роль</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Статус</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Дата регистрации</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Действия</th>
            </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
            <?php foreach ($users as $user): ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap"><?= $user->id ?></td>
                    <td class="px-6 py-4">
                        <div class="font-medium"><?= $user->fullName ?></div>
                    </td>
                    <td class="px-6 py-4">
                        <div class="font-medium"><?= $user->username ?></div>
                        <div class="text-sm text-gray-500"><?= $user->email ?></div>
                    </td>
                    <td class="px-6 py-4">
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full
                            <?= $user->role == 'admin' ? 'bg-purple-100 text-purple-800' : '' ?>
                            <?= $user->role == 'expert' ? 'bg-yellow-100 text-yellow-800' : '' ?>
                            <?= $user->role == 'user' ? 'bg-blue-100 text-blue-800' : '' ?>">
                            <?= $user->role ?>
                        </span>
                    </td>
                    <td class="px-6 py-4">
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?= $user->status == 10 ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>">
                            <?= $user->status == 10 ? 'Активен' : 'Заблокирован' ?>
                        </span>
                    </td>
                    <td class="px-6 py-4"><?= date('d.m.Y', $user->created_at) ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        <a href="#" class="text-blue-600 hover:text-blue-900 mr-3">Изменить</a>
                        <a href="#" class="text-red-600 hover:text-red-900" onclick="return confirm('Заблокировать пользователя?')">Блокировать</a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>