<?php
use yii\helpers\Url;
use yii\helpers\Html;
?>
<div class="p-6">
    <h1 class="text-2xl font-bold mb-6"><?= $model->isNewRecord ? 'Создать пользователя' : 'Изменить пользователя' ?></h1>

    <div class="bg-white p-6 rounded-lg shadow">
        <form method="post">
            <input type="hidden" name="<?= Yii::$app->request->csrfParam ?>" value="<?= Yii::$app->request->csrfToken ?>">

            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Фамилия *</label>
                    <input type="text" name="User[surname]" value="<?= Html::encode($model->surname) ?>" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                </div>
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Имя *</label>
                    <input type="text" name="User[name]" value="<?= Html::encode($model->name) ?>" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                </div>
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Отчество</label>
                    <input type="text" name="User[patronymic]" value="<?= Html::encode($model->patronymic) ?>" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                </div>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Логин *</label>
                <input type="text" name="User[username]" value="<?= Html::encode($model->username) ?>" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Email *</label>
                <input type="email" name="User[email]" value="<?= Html::encode($model->email) ?>" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
            </div>

            <?php if ($model->isNewRecord): ?>
                <div class="mb-4">
                    <label class="block text-gray-700 text-sm font-bold mb-2">Пароль *</label>
                    <input type="password" name="User[password]" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                </div>
            <?php endif; ?>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Роль</label>
                <select name="User[role]" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                    <option value="user" <?= $model->role == 'user' ? 'selected' : '' ?>>Участник</option>
                    <option value="expert" <?= $model->role == 'expert' ? 'selected' : '' ?>>Эксперт</option>
                    <option value="admin" <?= $model->role == 'admin' ? 'selected' : '' ?>>Администратор</option>
                </select>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Статус</label>
                <select name="User[status]" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                    <option value="10" <?= $model->status == 10 ? 'selected' : '' ?>>Активен</option>
                    <option value="0" <?= $model->status == 0 ? 'selected' : '' ?>>Заблокирован</option>
                </select>
            </div>

            <div class="flex items-center justify-between">
                <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline">
                    Сохранить
                </button>
                <a href="<?= Url::to(['users']) ?>" class="text-gray-600 hover:text-gray-800">Отмена</a>
            </div>
        </form>
    </div>
</div>