<?php
use yii\helpers\Url;
?>
<div class="p-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">Уведомления</h1>
        <a href="<?= Url::to(['notification-create']) ?>" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
            + Создать уведомление
        </a>
    </div>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Пользователь</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Заголовок</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Статус</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Дата</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Действия</th>
            </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
            <?php foreach ($notifications as $notification): ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap"><?= $notification->id ?></td>
                    <td class="px-6 py-4">
                        <div class="font-medium"><?= $notification->user->fullName ?? 'Пользователь удален' ?></div>
                        <div class="text-sm text-gray-500">ID: <?= $notification->user_id ?></div>
                    </td>
                    <td class="px-6 py-4">
                        <div class="font-medium"><?= $notification->title ?></div>
                        <div class="text-sm text-gray-500 truncate max-w-xs"><?= $notification->message ?></div>
                    </td>
                    <td class="px-6 py-4">
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?= $notification->is_read == 0 ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-800' ?>">
                            <?= $notification->is_read == 0 ? 'Новое' : 'Прочитано' ?>
                        </span>
                    </td>
                    <td class="px-6 py-4"><?= date('d.m.Y H:i', $notification->created_at) ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        <a href="#" class="text-red-600 hover:text-red-900" onclick="return confirm('Удалить уведомление?')">Удалить</a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>