<?php
use yii\helpers\Url;
use yii\helpers\Html;
?>
<div class="p-6">
    <h1 class="text-2xl font-bold mb-6">Создать уведомление</h1>

    <div class="bg-white p-6 rounded-lg shadow">
        <form method="post">
            <input type="hidden" name="<?= Yii::$app->request->csrfParam ?>" value="<?= Yii::$app->request->csrfToken ?>">

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Пользователь</label>
                <select name="Notification[user_id]" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                    <option value="">Выберите пользователя</option>
                    <?php foreach ($users as $user): ?>
                        <option value="<?= $user->id ?>"><?= Html::encode($user->fullName . ' (' . $user->email . ')') ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Заголовок</label>
                <input type="text" name="Notification[title]" value="" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Сообщение</label>
                <textarea name="Notification[message]" rows="4" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required></textarea>
            </div>

            <div class="flex items-center justify-between">
                <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline">
                    Отправить
                </button>
                <a href="<?= Url::to(['notifications']) ?>" class="text-gray-600 hover:text-gray-800">Отмена</a>
            </div>
        </form>
    </div>
</div>