<?php

use app\models\ExpertAssignments;
use yii\helpers\Url;
?>
<div class="p-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">Эксперты</h1>
    </div>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ФИО</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Контакты</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Назначен на</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Действия</th>
            </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
            <?php foreach ($experts as $expert):
                $assignments = ExpertAssignments::find()->where(['expert_id' => $expert->id])->all();
                ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap"><?= $expert->id ?></td>
                    <td class="px-6 py-4">
                        <div class="font-medium"><?= $expert->fullName ?></div>
                    </td>
                    <td class="px-6 py-4">
                        <div><?= $expert->email ?></div>
                        <div class="text-sm text-gray-500">Логин: <?= $expert->username ?></div>
                    </td>
                    <td class="px-6 py-4">
                        <?php if ($assignments): ?>
                            <?php foreach ($assignments as $ass): ?>
                                <div class="text-sm">
                                    • Конкурс #<?= $ass->contest_id ?>
                                    <?php if ($ass->nomination_id): ?> / Номинация #<?= $ass->nomination_id ?><?php endif; ?>
                                    <?php if ($ass->age_category_id): ?> / Возраст #<?= $ass->age_category_id ?><?php endif; ?>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <span class="text-gray-400">Не назначен</span>
                        <?php endif; ?>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        <a href="<?= Url::to(['assign-expert', 'expert_id' => $expert->id]) ?>" class="text-blue-600 hover:text-blue-900 mr-3">Назначить</a>
                        <a href="#" class="text-red-600 hover:text-red-900" onclick="return confirm('Удалить эксперта?')">Удалить</a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>