<div class="p-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">Конкурсы</h1>
        <a href="<?= \yii\helpers\Url::to(['contest-create']) ?>" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
            + Создать конкурс
        </a>
    </div>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Название</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Даты</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Статус</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Действия</th>
            </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
            <?php foreach ($contests as $contest): ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap"><?= $contest->id ?></td>
                    <td class="px-6 py-4"><?= $contest->name ?></td>
                    <td class="px-6 py-4"><?= $contest->start_date ?> - <?= $contest->end_date ?></td>
                    <td class="px-6 py-4">
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?= $contest->status == 1 ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>">
                            <?= $contest->status == 1 ? 'Активен' : 'Неактивен' ?>
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        <a href="<?= \yii\helpers\Url::to(['contest-update', 'id' => $contest->id]) ?>" class="text-blue-600 hover:text-blue-900 mr-3">Изменить</a>
                        <a href="<?= \yii\helpers\Url::to(['contest-delete', 'id' => $contest->id]) ?>" class="text-red-600 hover:text-red-900" onclick="return confirm('Удалить конкурс?')">Удалить</a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>