<div class="p-6">
    <h1 class="text-2xl font-bold mb-6"><?= $model->isNewRecord ? 'Создать конкурс' : 'Изменить конкурс' ?></h1>

    <div class="bg-white p-6 rounded-lg shadow">
        <form method="post">
            <input type="hidden" name="<?= Yii::$app->request->csrfParam ?>" value="<?= Yii::$app->request->csrfToken ?>">

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Название</label>
                <input type="text" name="Contests[name]" value="<?= $model->name ?>" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Описание</label>
                <textarea name="Contests[description]" rows="4" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline"><?= $model->description ?></textarea>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Дата начала</label>
                    <input type="date" name="Contests[start_date]" value="<?= $model->start_date ?>" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                </div>
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Дата окончания</label>
                    <input type="date" name="Contests[end_date]" value="<?= $model->end_date ?>" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                </div>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Статус</label>
                <select name="Contests[status]" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                    <option value="1" <?= $model->status == 1 ? 'selected' : '' ?>>Активен</option>
                    <option value="0" <?= $model->status == 0 ? 'selected' : '' ?>>Неактивен</option>
                </select>
            </div>

            <div class="flex items-center justify-between">
                <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline">
                    Сохранить
                </button>
                <a href="<?= \yii\helpers\Url::to(['contests']) ?>" class="text-gray-600 hover:text-gray-800">Отмена</a>
            </div>
        </form>
    </div>
</div>