<?php
use yii\helpers\Url;
use yii\helpers\Html;
?>
<div class="p-6">
    <h1 class="text-2xl font-bold mb-6">
        <?= $model->isNewRecord ? 'Создать категорию' : 'Изменить категорию' ?>
        <span class="text-sm font-normal text-gray-600">(<?= $type == 'nomination' ? 'Номинация' : 'Возрастная категория' ?>)</span>
    </h1>

    <div class="bg-white p-6 rounded-lg shadow">
        <form method="post">
            <input type="hidden" name="<?= Yii::$app->request->csrfParam ?>" value="<?= Yii::$app->request->csrfToken ?>">
            <input type="hidden" name="Categories[type]" value="<?= $type ?>">

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Название</label>
                <input type="text" name="Categories[name]" value="<?= Html::encode($model->name) ?>" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Конкурс</label>
                <select name="Categories[contest_id]" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                    <option value="">Выберите конкурс</option>
                    <?php foreach ($contests as $contest): ?>
                        <option value="<?= $contest->id ?>" <?= $model->contest_id == $contest->id ? 'selected' : '' ?>>
                            <?= Html::encode($contest->name) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Статус</label>
                <select name="Categories[status]" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                    <option value="1" <?= $model->status == 1 ? 'selected' : '' ?>>Активна</option>
                    <option value="0" <?= $model->status == 0 ? 'selected' : '' ?>>Неактивна</option>
                </select>
            </div>

            <div class="flex items-center justify-between">
                <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline">
                    Сохранить
                </button>
                <a href="<?= Url::to(['categories', 'type' => $type]) ?>" class="text-gray-600 hover:text-gray-800">Отмена</a>
            </div>
        </form>
    </div>
</div>