<?php
use yii\helpers\Url;
?>
<div class="p-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">
            <?= $type == 'nomination' ? 'Номинации' : 'Возрастные категории' ?>
        </h1>
        <a href="<?= Url::to(['category-create', 'type' => $type]) ?>" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
            + Создать
        </a>
    </div>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Название</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Конкурс</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Статус</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Дата создания</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Действия</th>
            </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
            <?php foreach ($categories as $category): ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap"><?= $category->id ?></td>
                    <td class="px-6 py-4">
                        <div class="font-medium"><?= $category->name ?></div>
                        <div class="text-sm text-gray-500">Тип: <?= $category->type ?></div>
                    </td>
                    <td class="px-6 py-4">
                        <?= $category->contest->name ?? 'Не указан' ?>
                    </td>
                    <td class="px-6 py-4">
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?= $category->status == 1 ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>">
                            <?= $category->status == 1 ? 'Активна' : 'Неактивна' ?>
                        </span>
                    </td>
                    <td class="px-6 py-4"><?= date('d.m.Y', $category->created_at) ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        <a href="<?= Url::to(['category-update', 'id' => $category->id]) ?>" class="text-blue-600 hover:text-blue-900 mr-3">Изменить</a>
                        <a href="<?= Url::to(['category-delete', 'id' => $category->id]) ?>" class="text-red-600 hover:text-red-900" onclick="return confirm('Удалить категорию?')">Удалить</a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>