<?php
use yii\helpers\Url;
use yii\helpers\Html;
?>
<div class="p-6">
    <h1 class="text-2xl font-bold mb-6">Назначение эксперта: <?= Html::encode($expert->fullName) ?></h1>

    <div class="bg-white p-6 rounded-lg shadow">
        <form method="post">
            <input type="hidden" name="<?= Yii::$app->request->csrfParam ?>" value="<?= Yii::$app->request->csrfToken ?>">

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Конкурс</label>
                <select name="ExpertAssignments[contest_id]" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" required>
                    <option value="">Выберите конкурс</option>
                    <?php foreach ($contests as $contest): ?>
                        <option value="<?= $contest->id ?>"><?= Html::encode($contest->name) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Номинация (опционально)</label>
                    <select name="ExpertAssignments[nomination_id]" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                        <option value="">Все номинации</option>
                        <?php foreach ($nominations as $nomination): ?>
                            <option value="<?= $nomination->id ?>"><?= Html::encode($nomination->name) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Возрастная категория (опционально)</label>
                    <select name="ExpertAssignments[age_category_id]" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                        <option value="">Все возрастные категории</option>
                        <?php foreach ($ageCategories as $category): ?>
                            <option value="<?= $category->id ?>"><?= Html::encode($category->name) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>

            <div class="flex items-center justify-between">
                <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline">
                    Назначить
                </button>
                <a href="<?= Url::to(['experts']) ?>" class="text-gray-600 hover:text-gray-800">Отмена</a>
            </div>
        </form>
    </div>
</div>