<div class="p-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">Заявки</h1>
        <div class="flex gap-4">
            <form method="get" class="flex">
                <input type="text" name="search" value="<?= $search ?>" placeholder="Поиск по фамилии" class="border rounded-l py-2 px-3">
                <button type="submit" class="bg-gray-200 hover:bg-gray-300 px-4 rounded-r">Найти</button>
            </form>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Работа</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Участник</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Статус</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Дата</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Действия</th>
            </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
            <?php foreach ($applications as $app): ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap"><?= $app->id ?></td>
                    <td class="px-6 py-4">
                        <div class="font-medium"><?= $app->work_name ?></div>
                        <div class="text-sm text-gray-500"><?= $app->nomination->name ?? '' ?></div>
                    </td>
                    <td class="px-6 py-4">
                        <div><?= $app->user->fullName ?></div>
                        <div class="text-sm text-gray-500"><?= $app->user->email ?></div>
                    </td>
                    <td class="px-6 py-4">
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full
                            <?= $app->status == 'new' ? 'bg-blue-100 text-blue-800' : '' ?>
                            <?= $app->status == 'blocked' ? 'bg-red-100 text-red-800' : '' ?>
                            <?= $app->status == 'accepted' ? 'bg-green-100 text-green-800' : '' ?>">
                            <?= $app->status ?>
                        </span>
                    </td>
                    <td class="px-6 py-4"><?= date('d.m.Y', $app->created_at) ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        <a href="<?= \yii\helpers\Url::to(['application-view', 'id' => $app->id]) ?>" class="text-blue-600 hover:text-blue-900 mr-3">Просмотр</a>
                        <?php if ($app->status != 'blocked'): ?>
                            <a href="<?= \yii\helpers\Url::to(['application-block', 'id' => $app->id]) ?>" class="text-red-600 hover:text-red-900" onclick="return confirm('Заблокировать заявку?')">Блокировать</a>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>