<?php
use yii\helpers\Url;
use yii\helpers\Html;
?>
<div class="p-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">Заявка #<?= $application->id ?></h1>
        <div>
            <?php if ($application->status != 'blocked'): ?>
                <a href="<?= Url::to(['application-block', 'id' => $application->id]) ?>" class="bg-red-500 hover:bg-red-700 text-white font-bold py-2 px-4 rounded" onclick="return confirm('Заблокировать заявку?')">
                    Блокировать
                </a>
            <?php endif; ?>
        </div>
    </div>

    <div class="bg-white p-6 rounded-lg shadow">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <h3 class="text-lg font-semibold mb-4">Информация о работе</h3>
                <div class="space-y-3">
                    <div>
                        <span class="font-medium">Название работы:</span>
                        <div class="text-gray-700"><?= Html::encode($application->work_name) ?></div>
                    </div>
                    <div>
                        <span class="font-medium">Номинация:</span>
                        <div class="text-gray-700"><?= $application->nomination->name ?? 'Не указана' ?></div>
                    </div>
                    <div>
                        <span class="font-medium">Возрастная категория:</span>
                        <div class="text-gray-700"><?= $application->ageCategory->name ?? 'Не указана' ?></div>
                    </div>
                    <div>
                        <span class="font-medium">Учреждение:</span>
                        <div class="text-gray-700"><?= Html::encode($application->institution) ?: 'Не указано' ?></div>
                    </div>
                    <div>
                        <span class="font-medium">Руководитель:</span>
                        <div class="text-gray-700"><?= Html::encode($application->leader) ?: 'Не указан' ?></div>
                    </div>
                </div>
            </div>

            <div>
                <h3 class="text-lg font-semibold mb-4">Информация об участнике</h3>
                <div class="space-y-3">
                    <div>
                        <span class="font-medium">ФИО:</span>
                        <div class="text-gray-700"><?= Html::encode($application->user->fullName) ?></div>
                    </div>
                    <div>
                        <span class="font-medium">Email:</span>
                        <div class="text-gray-700"><?= Html::encode($application->user->email) ?></div>
                    </div>
                    <div>
                        <span class="font-medium">Логин:</span>
                        <div class="text-gray-700"><?= Html::encode($application->user->username) ?></div>
                    </div>
                    <div>
                        <span class="font-medium">Конкурс:</span>
                        <div class="text-gray-700"><?= $application->contest->name ?? 'Не указан' ?></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="mt-6">
            <h3 class="text-lg font-semibold mb-4">Файл работы</h3>
            <?php if ($application->file_path): ?>
                <div class="bg-gray-50 p-4 rounded">
                    <div class="flex items-center">
                        <svg class="w-8 h-8 text-gray-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        <div>
                            <div class="font-medium"><?= basename($application->file_path) ?></div>
                            <a href="<?= Url::to(['/site/download', 'file' => $application->file_path]) ?>" class="text-blue-600 hover:text-blue-800 text-sm">
                                Скачать файл
                            </a>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <div class="text-gray-500">Файл не загружен</div>
            <?php endif; ?>
        </div>

        <div class="mt-6">
            <h3 class="text-lg font-semibold mb-4">Статус заявки</h3>
            <div class="flex items-center">
                <span class="px-4 py-2 rounded-full font-semibold text-sm
                    <?= $application->status == 'new' ? 'bg-blue-100 text-blue-800' : '' ?>
                    <?= $application->status == 'blocked' ? 'bg-red-100 text-red-800' : '' ?>
                    <?= $application->status == 'accepted' ? 'bg-green-100 text-green-800' : '' ?>
                    <?= $application->status == 'rated' ? 'bg-purple-100 text-purple-800' : '' ?>">
                    <?= $application->status ?>
                </span>
                <div class="ml-4 text-gray-600">
                    Создана: <?= date('d.m.Y H:i', $application->created_at) ?>
                    <?php if ($application->updated_at != $application->created_at): ?>
                        <br>Обновлена: <?= date('d.m.Y H:i', $application->updated_at) ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>