<?php

namespace app\services;

use app\models\Notification;
use Yii;

class NotificationService
{
    /**
     * Отправляет уведомление о смене статуса заявки
     */
    public static function sendApplicationStatusChange($userId, $applicationId, $oldStatus, $newStatus)
    {
        $statusLabels = [
            'new' => 'Новая',
            'approved' => 'Принята',
            'rejected' => 'Отклонена',
            'blocked' => 'Заблокирована',
            'evaluated' => 'Оценена',
        ];

        $title = 'Изменен статус заявки';
        $message = sprintf(
            'Статус вашей заявки изменен с "%s" на "%s"',
            $statusLabels[$oldStatus] ?? $oldStatus,
            $statusLabels[$newStatus] ?? $newStatus
        );

        return Notification::create(
            $userId,
            $title,
            $message,
            Notification::TYPE_APPLICATION,
            $applicationId,
            'application'
        );
    }

    /**
     * Отправляет уведомление о новом конкурсе
     */
    public static function sendNewContestNotification($userId, $contestId, $contestName)
    {
        $title = 'Новый конкурс доступен';
        $message = sprintf(
            'Доступен новый конкурс: "%s". Вы можете подать заявку на участие.',
            $contestName
        );

        return Notification::create(
            $userId,
            $title,
            $message,
            Notification::TYPE_CONTEST,
            $contestId,
            'contest'
        );
    }

    /**
     * Отправляет системное уведомление
     */
    public static function sendSystemNotification($userId, $title, $message)
    {
        return Notification::create(
            $userId,
            $title,
            $message,
            Notification::TYPE_SYSTEM
        );
    }
}

//эта хрень работает через раз, мб отключю ее нахрен, чат гпт кал написал, но если знаешь че с сервисом делать, то буду рад помощи)