<?php
namespace app\models;

use Yii;
use yii\base\Model;

class SignupForm extends Model
{
    public $name;
    public $surname;
    public $patronymic;
    public $username;
    public $email;
    public $password;
    public $password_repeat;
    public $rules;

    public function rules()
    {
        return [
            [['name', 'surname', 'username', 'email', 'password', 'password_repeat', 'rules'], 'required'],
            [['name', 'surname', 'patronymic'], 'match', 'pattern' => '/^[а-яА-Я\s\-]+$/u'],
            ['username', 'match', 'pattern' => '/^[a-zA-Z0-9\-]+$/'],
            ['username', 'unique', 'targetClass' => User::class],
            ['email', 'email'],
            ['email', 'unique', 'targetClass' => User::class],
            ['password', 'string', 'min' => 6],
            ['password_repeat', 'compare', 'compareAttribute' => 'password'],
            ['rules', 'compare', 'compareValue' => true, 'message' => 'Необходимо согласие с правилами'],
        ];
    }

    public function attributeLabels()
    {
        return [
            'name' => 'Имя',
            'surname' => 'Фамилия',
            'patronymic' => 'Отчество',
            'username' => 'Логин',
            'email' => 'Email',
            'password' => 'Пароль',
            'password_repeat' => 'Повторите пароль',
            'rules' => 'Согласен с правилами',
        ];
    }

    public function signup()
    {
        if (!$this->validate()) {
            Yii::error('Validation failed: ' . print_r($this->errors, true));
            return false;
        }

        $user = new User();
        $user->name = $this->name;
        $user->surname = $this->surname;
        $user->patronymic = $this->patronymic;
        $user->username = $this->username;
        $user->email = $this->email;
        $user->setPassword($this->password);
        $user->status = 10;
        $user->role = 'user';

        if ($user->save()) {
            Yii::info('User registered successfully: ' . $user->id);
            return true;
        } else {
            Yii::error('User save failed: ' . print_r($user->errors, true));
            return false;
        }
    }
}