<?php
namespace app\models;

use Yii;

class Rating extends \yii\db\ActiveRecord
{
    public $mastery;
    public $artistry;
    public $stage_culture;

    public static function tableName()
    {
        return 'ratings';
    }

    public function rules()
    {
        return [
            [['application_id', 'expert_id'], 'required'],
            [['mastery', 'artistry', 'stage_culture'], 'integer', 'min' => 0, 'max' => 100],
            [['comment'], 'string'],
        ];
    }

    public function beforeSave($insert)
    {
        if (parent::beforeSave($insert)) {
            $this->criteria_data = json_encode([
                'mastery' => $this->mastery,
                'artistry' => $this->artistry,
                'stage_culture' => $this->stage_culture,
            ]);

            // Считаем общий балл
            $this->total_score = $this->mastery + $this->artistry + $this->stage_culture;

            if ($insert) {
                $this->created_at = time();
            }
            $this->updated_at = time();

            return true;
        }
        return false;
    }

    public function afterFind()
    {
        parent::afterFind();

        if ($this->criteria_data) {
            $data = json_decode($this->criteria_data, true);
            $this->mastery = $data['mastery'] ?? 0;
            $this->artistry = $data['artistry'] ?? 0;
            $this->stage_culture = $data['stage_culture'] ?? 0;
        }
    }

    public function getApplication()
    {
        return $this->hasOne(Applications::class, ['id' => 'application_id']);
    }
}