<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "notifications".
 *
 * @property int $id
 * @property int $user_id
 * @property string $title
 * @property string $message
 * @property int $is_read
 * @property int $created_at
 *
 * @property User $user
 */
class Notification extends \yii\db\ActiveRecord
{
    const STATUS_UNREAD = 0;
    const STATUS_READ = 1;

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'notifications';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['user_id', 'title', 'message', 'created_at'], 'required'],
            [['user_id', 'is_read', 'created_at'], 'integer'],
            [['message'], 'string'],
            [['title'], 'string', 'max' => 255],
            ['is_read', 'default', 'value' => self::STATUS_UNREAD],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::class, 'targetAttribute' => ['user_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'User ID',
            'title' => 'Заголовок',
            'message' => 'Сообщение',
            'is_read' => 'Прочитано',
            'created_at' => 'Создано',
        ];
    }

    /**
     * Gets query for [[User]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }


    public static function create($userId, $title, $message)
    {
        $notification = new self();
        $notification->user_id = $userId;
        $notification->title = $title;
        $notification->message = $message;
        $notification->is_read = self::STATUS_UNREAD;
        $notification->created_at = time();

        return $notification->save();
    }


    public function markAsRead()
    {
        $this->is_read = self::STATUS_READ;
        return $this->save();
    }


    public static function getUnreadCount($userId)
    {
        return self::find()
            ->where(['user_id' => $userId, 'is_read' => self::STATUS_UNREAD])
            ->count();
    }

    public static function getUserNotifications($userId, $limit = null)
    {
        $query = self::find()
            ->where(['user_id' => $userId])
            ->orderBy(['created_at' => SORT_DESC]);

        if ($limit) {
            $query->limit($limit);
        }

        return $query->all();
    }
}