<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "expert_assignments".
 *
 * @property int $id
 * @property int $expert_id
 * @property int $contest_id
 * @property int|null $nomination_id
 * @property int|null $age_category_id
 * @property int $created_at
 *
 * @property Categories $ageCategory
 * @property Contests $contest
 * @property User $expert
 * @property Categories $nomination
 */
class ExpertAssignments extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'expert_assignments';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['expert_id', 'contest_id', 'created_at'], 'required'],
            [['expert_id', 'contest_id', 'nomination_id', 'age_category_id', 'created_at'], 'integer'],
            [['age_category_id'], 'exist', 'skipOnError' => true, 'targetClass' => Categories::class, 'targetAttribute' => ['age_category_id' => 'id']],
            [['contest_id'], 'exist', 'skipOnError' => true, 'targetClass' => Contests::class, 'targetAttribute' => ['contest_id' => 'id']],
            [['expert_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::class, 'targetAttribute' => ['expert_id' => 'id']],
            [['nomination_id'], 'exist', 'skipOnError' => true, 'targetClass' => Categories::class, 'targetAttribute' => ['nomination_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'expert_id' => 'Expert ID',
            'contest_id' => 'Contest ID',
            'nomination_id' => 'Nomination ID',
            'age_category_id' => 'Age Category ID',
            'created_at' => 'Создано',
        ];
    }

    /**
     * Gets query for [[AgeCategory]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getAgeCategory()
    {
        return $this->hasOne(Categories::class, ['id' => 'age_category_id']);
    }

    /**
     * Gets query for [[Contest]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getContest()
    {
        return $this->hasOne(Contests::class, ['id' => 'contest_id']);
    }

    /**
     * Gets query for [[Expert]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getExpert()
    {
        return $this->hasOne(User::class, ['id' => 'expert_id']);
    }

    /**
     * Gets query for [[Nomination]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getNomination()
    {
        return $this->hasOne(Categories::class, ['id' => 'nomination_id']);
    }
}
