<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "contests".
 *
 * @property int $id
 * @property string $name
 * @property string|null $description
 * @property string|null $start_date
 * @property string|null $end_date
 * @property int $status
 * @property int $created_at
 * @property int $updated_at
 *
 * @property Applications[] $applications
 * @property Categories[] $categories
 * @property ExpertAssignments[] $expertAssignments
 */
class Contests extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'contests';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'created_at', 'updated_at'], 'required'],
            [['description'], 'string'],
            [['start_date', 'end_date'], 'safe'],
            [['status', 'created_at', 'updated_at'], 'integer'],
            [['name'], 'string', 'max' => 255],
            [['image_path'], 'string', 'max' => 500],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Название',
            'description' => 'Описание',
            'start_date' => 'Начало',
            'end_date' => 'Конец',
            'status' => 'Статус',
            'created_at' => 'Создано',
            'updated_at' => 'Обновлено',
            'image_path' => 'Изображение',
        ];
    }

    public function getApplications()
    {
        return $this->hasMany(Applications::class, ['contest_id' => 'id']);
    }

    /**
     * Gets query for [[Categories]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCategories()
    {
        return $this->hasMany(Categories::class, ['contest_id' => 'id']);
    }

    /**
     * Gets query for [[ExpertAssignments]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getExpertAssignments()
    {
        return $this->hasMany(ExpertAssignments::class, ['contest_id' => 'id']);
    }
}
