<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "categories".
 *
 * @property int $id
 * @property string $name
 * @property string $type
 * @property int $contest_id
 * @property int $status
 * @property int $created_at
 *
 * @property Applications[] $applications
 * @property Applications[] $applications0
 * @property Contests $contest
 * @property ExpertAssignments[] $expertAssignments
 * @property ExpertAssignments[] $expertAssignments0
 */
class Categories extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'categories';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'type', 'contest_id', 'created_at'], 'required'],
            [['contest_id', 'status', 'created_at'], 'integer'],
            [['name'], 'string', 'max' => 255],
            [['type'], 'string', 'max' => 50],
            [['contest_id'], 'exist', 'skipOnError' => true, 'targetClass' => Contests::class, 'targetAttribute' => ['contest_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Название',
            'type' => 'Тип',
            'contest_id' => 'Конкурс',
            'status' => 'Статус',
            'created_at' => 'Создано',
        ];
    }

    /**
     * Gets query for [[Applications]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getApplications()
    {
        return $this->hasMany(Applications::class, ['age_category_id' => 'id']);
    }

    /**
     * Gets query for [[Applications0]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getApplications0()
    {
        return $this->hasMany(Applications::class, ['nomination_id' => 'id']);
    }

    /**
     * Gets query for [[Contest]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getContest()
    {
        return $this->hasOne(Contests::class, ['id' => 'contest_id']);
    }

    /**
     * Gets query for [[ExpertAssignments]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getExpertAssignments()
    {
        return $this->hasMany(ExpertAssignments::class, ['age_category_id' => 'id']);
    }

    /**
     * Gets query for [[ExpertAssignments0]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getExpertAssignments0()
    {
        return $this->hasMany(ExpertAssignments::class, ['nomination_id' => 'id']);
    }
}
