<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "applications".
 *
 * @property int $id
 * @property int $user_id
 * @property int $contest_id
 * @property int $nomination_id
 * @property int $age_category_id
 * @property string $work_name
 * @property string $file_path
 * @property string|null $institution
 * @property string|null $leader
 * @property string $status
 * @property float|null $final_score
 * @property int|null $place
 * @property string|null $diploma_path
 * @property int $created_at
 * @property int $updated_at
 *
 * @property Categories $ageCategory
 * @property Contests $contest
 * @property Categories $nomination
 * @property User $user
 */
class Applications extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'applications';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['user_id', 'contest_id', 'nomination_id', 'age_category_id', 'work_name', 'file_path', 'created_at', 'updated_at'], 'required'],
            [['user_id', 'contest_id', 'nomination_id', 'age_category_id', 'place', 'created_at', 'updated_at'], 'integer'],
            [['final_score'], 'number'],
            [['work_name', 'institution', 'leader'], 'string', 'max' => 255],
            [['file_path', 'diploma_path'], 'string', 'max' => 500],
            [['status'], 'string', 'max' => 50],
            [['age_category_id'], 'exist', 'skipOnError' => true, 'targetClass' => Categories::class, 'targetAttribute' => ['age_category_id' => 'id']],
            [['contest_id'], 'exist', 'skipOnError' => true, 'targetClass' => Contests::class, 'targetAttribute' => ['contest_id' => 'id']],
            [['nomination_id'], 'exist', 'skipOnError' => true, 'targetClass' => Categories::class, 'targetAttribute' => ['nomination_id' => 'id']],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::class, 'targetAttribute' => ['user_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'User ID',
            'contest_id' => 'Contest ID',
            'nomination_id' => 'Nomination ID',
            'age_category_id' => 'Age Category ID',
            'work_name' => 'Название работы',
            'file_path' => 'Файл',
            'institution' => 'Учереждение',
            'leader' => 'Лидер',
            'status' => 'Статус',
            'final_score' => 'Итоговый счет',
            'place' => 'Место',
            'diploma_path' => 'Награда',
            'created_at' => 'Создано',
            'updated_at' => 'Обновлено',
        ];
    }

    /**
     * Gets query for [[AgeCategory]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getAgeCategory()
    {
        return $this->hasOne(Categories::class, ['id' => 'age_category_id']);
    }

    /**
     * Gets query for [[Contest]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getContest()
    {
        return $this->hasOne(Contests::class, ['id' => 'contest_id']);
    }

    /**
     * Gets query for [[Nomination]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getNomination()
    {
        return $this->hasOne(Categories::class, ['id' => 'nomination_id']);
    }

    /**
     * Gets query for [[Ratings]].
     *
     * @return \yii\db\ActiveQuery
     */

    /**
     * Gets query for [[User]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }
}
