<?php
namespace app\models;

use Yii;
use yii\base\Model;
use yii\web\UploadedFile;

class ApplicationForm extends Model
{
    public $contest_id;
    public $nomination_id;
    public $age_category_id;
    public $work_name;
    public $institution;
    public $leader;
    public $file;

    public function rules()
    {
        return [
            [['contest_id', 'nomination_id', 'age_category_id', 'work_name'], 'required'],
            [['contest_id', 'nomination_id', 'age_category_id'], 'integer'],
            [['work_name', 'institution', 'leader'], 'string', 'max' => 255],
            ['file', 'file', 'extensions' => 'mp4, mkv, png, avi, jpg, pdf, jpeg', 'maxSize' => 100 * 1024 * 1024],
        ];
    }

    public function attributeLabels()
    {
        return [
            'nomination_id' => 'Номинация',
            'age_category_id' => 'Возрастная категория',
            'work_name' => 'Название работы',
            'file' => 'Файл работы',
            'institution' => 'Учреждение',
            'leader' => 'Руководитель',
        ];
    }

    public function save()
    {
        if (!$this->validate()) {
            return false;
        }

        $application = new Applications();
        $application->user_id = Yii::$app->user->id;
        $application->contest_id = $this->contest_id;
        $application->nomination_id = $this->nomination_id;
        $application->age_category_id = $this->age_category_id;
        $application->work_name = $this->work_name;
        $application->institution = $this->institution;
        $application->leader = $this->leader;
        $application->status = 'new';
        $application->created_at = time();
        $application->updated_at = time();

        $file = UploadedFile::getInstance($this, 'file');
        if ($file) {
            $fileName = Yii::$app->security->generateRandomString() . '.' . $file->extension;
            $filePath = 'uploads/' . $fileName;
            if ($file->saveAs($filePath)) {
                $application->file_path = $filePath;
            }
        }

        return $application->save();
    }
}