<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%expert_assignments}}`.
 */
class m251123_150113_create_expert_assignments_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%expert_assignments}}', [
            'id' => $this->primaryKey(),
            'expert_id' => $this->integer()->notNull(),
            'contest_id' => $this->integer()->notNull(),
            'nomination_id' => $this->integer(),
            'age_category_id' => $this->integer(),
            'created_at' => $this->integer()->notNull(),
        ]);

        $this->addForeignKey(
            'fk-expert_assignments-expert_id',
            '{{%expert_assignments}}',
            'expert_id',
            '{{%users}}',
            'id',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk-expert_assignments-contest_id',
            '{{%expert_assignments}}',
            'contest_id',
            '{{%contests}}',
            'id',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk-expert_assignments-nomination_id',
            '{{%expert_assignments}}',
            'nomination_id',
            '{{%categories}}',
            'id',
            'CASCADE'
        );
        $this->addForeignKey(
            'fk-expert_assignments-age_category_id',
            '{{%expert_assignments}}',
            'age_category_id',
            '{{%categories}}',
            'id',
            'CASCADE'
        );

        $this->createIndex('idx-expert_assignments-expert_id', '{{%expert_assignments}}', 'expert_id');
        $this->createIndex('idx-expert_assignments-contest_id', '{{%expert_assignments}}', 'contest_id');
    }


    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%expert_assignments}}');
    }
}
