<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%ratings}}`.
 */
class m251123_150100_create_ratings_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%ratings}}', [
            'id' => $this->primaryKey(),
            'application_id' => $this->integer()->notNull(),
            'expert_id' => $this->integer()->notNull(),
            'criteria_data' => $this->json(), // JSON с критериями
            'total_score' => $this->integer()->notNull()->defaultValue(0),
            'comment' => $this->text(),
            'status' => $this->string(50)->notNull()->defaultValue('draft'),
            'created_at' => $this->integer()->notNull(),
            'updated_at' => $this->integer()->notNull(),
        ]);

        $this->addForeignKey(
            'fk-ratings-application_id',
            '{{%ratings}}',
            'application_id',
            '{{%applications}}',
            'id',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk-ratings-expert_id',
            '{{%ratings}}',
            'expert_id',
            '{{%users}}',
            'id',
            'CASCADE'
        );

        $this->createIndex('idx-ratings-application_id', '{{%ratings}}', 'application_id');
        $this->createIndex('idx-ratings-expert_id', '{{%ratings}}', 'expert_id');
    }


    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%ratings}}');
    }
}
