<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%applications}}`.
 */
class m251123_150053_create_applications_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%applications}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'contest_id' => $this->integer()->notNull(),
            'nomination_id' => $this->integer()->notNull(),
            'age_category_id' => $this->integer()->notNull(),
            'work_name' => $this->string(255)->notNull(),
            'file_path' => $this->string(500)->notNull(),
            'institution' => $this->string(255),
            'leader' => $this->string(255),

            'status' => $this->string(50)->notNull()->defaultValue('new'),
            'final_score' => $this->decimal(5,2),
            'place' => $this->integer(),
            'diploma_path' => $this->string(500),
            'created_at' => $this->integer()->notNull(),
            'updated_at' => $this->integer()->notNull(),
        ]);

        // Внешние ключи
        $this->addForeignKey(
            'fk-applications-user_id',
            '{{%applications}}',
            'user_id',
            '{{%users}}',
            'id',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk-applications-contest_id',
            '{{%applications}}',
            'contest_id',
            '{{%contests}}',
            'id',
            'CASCADE');
        $this->addForeignKey(
            'fk-applications-nomination_id',
            '{{%applications}}',
            'nomination_id',
            '{{%categories}}',
            'id',
            'CASCADE'
        );
        $this->addForeignKey(
            'fk-applications-age_category_id',
            '{{%applications}}',
            'age_category_id',
            '{{%categories}}',
            'id',
            'CASCADE'
        );
        $this->createIndex('idx-applications-user_id', '{{%applications}}', 'user_id');
        $this->createIndex('idx-applications-contest_id', '{{%applications}}', 'contest_id');
    }


    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%applications}}');
    }
}
