<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%categories}}`.
 */
class m251123_150046_create_categories_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%categories}}', [
            'id' => $this->primaryKey(),
            'name' => $this->string(255)->notNull(),
            'type' => $this->string(50)->notNull(),
            'contest_id' => $this->integer()->notNull(),
            'status' => $this->smallInteger()->notNull()->defaultValue(1),
            'created_at' => $this->integer()->notNull(),
        ]);

        $this->addForeignKey(
            'fk-categories-contest_id',
            '{{%categories}}',
            'contest_id',
            '{{%contests}}',
            'id',
            'CASCADE'
        );

        $this->createIndex('idx-categories-contest_id', '{{%categories}}', 'contest_id');
    }

    public function safeDown()
    {
        $this->dropTable('{{%applications}}');
    }
    /**
     * {@inheritdoc}
     */
}
