<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%contests}}`.
 */
class m251123_150038_create_contests_table extends Migration
{

    // конкурсы
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%contests}}', [
            'id' => $this->primaryKey(),
            'name' => $this->string(255)->notNull(),
            'description' => $this->text(),
            'start_date' => $this->date(),
            'end_date' => $this->date(),
            'status' => $this->smallInteger()->notNull()->defaultValue(1),
            'created_at' => $this->integer()->notNull(),
            'updated_at' => $this->integer()->notNull(),
        ]);

        $this->createIndex('idx-contests-status', '{{%contests}}', 'status');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%contests}}');
    }
}
