<?php
// controllers/ExpertController.php
namespace app\controllers;

use Yii;
use app\models\Applications;
use app\models\Rating;
use yii\web\Controller;
use yii\filters\AccessControl;

class ExpertController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                        'matchCallback' => function($rule, $action) {
                            $user = Yii::$app->user->identity;
                            return $user->role === 'expert' || $user->role === 'admin';
                        }
                    ],
                ],
                'denyCallback' => function() {
                    Yii::$app->session->setFlash('error', 'Доступ запрещен. Только для экспертов.');
                    return Yii::$app->response->redirect(['site/index']);
                }
            ],
        ];
    }

    public function actionIndex()
    {
        $expertId = Yii::$app->user->id;

        $assignments = \app\models\ExpertAssignments::find()
            ->where(['expert_id' => $expertId])
            ->all();

        if (empty($assignments)) {
            $applications = [];
        } else {
            $contestIds = [];
            foreach ($assignments as $assignment) {
                $contestIds[] = $assignment->contest_id;
            }

            $applications = Applications::find()
                ->where(['status' => 'approved'])
                ->andWhere(['in', 'contest_id', $contestIds])
                ->orderBy(['created_at' => SORT_DESC])
                ->all();
        }

        return $this->render('index', [
            'applications' => $applications,
        ]);
    }


    public function actionRate($id)
    {
        $application = Applications::findOne($id);
        if (!$application) {
            Yii::$app->session->setFlash('error', 'Заявка не найдена');
            return $this->redirect(['index']);
        }
        $assignment = \app\models\ExpertAssignments::find()
            ->where([
                'expert_id' => Yii::$app->user->id,
                'contest_id' => $application->contest_id
            ])
            ->one();

        if (!$assignment) {
            Yii::$app->session->setFlash('error', 'Вы не назначены на этот конкурс');
            return $this->redirect(['index']);
        }

        $rating = Rating::findOne([
            'application_id' => $id,
            'expert_id' => Yii::$app->user->id
        ]);

        if (!$rating) {
            $rating = new Rating();
            $rating->application_id = $id;
            $rating->expert_id = Yii::$app->user->id;
            $rating->status = 'draft';
        }

        if (Yii::$app->request->isPost) {
            $post = Yii::$app->request->post();

            $rating->mastery = $post['mastery'] ?? 0;
            $rating->artistry = $post['artistry'] ?? 0;
            $rating->stage_culture = $post['stage_culture'] ?? 0;
            $rating->comment = $post['comment'] ?? '';

            if (isset($post['save_draft'])) {
                $rating->status = 'draft';
                $message = 'Черновик сохранен';
            } elseif (isset($post['complete'])) {
                $rating->status = 'completed';
                $message = 'Оценка завершена';
            }

            if ($rating->save()) {
                Yii::$app->session->setFlash('success', $message);
                return $this->redirect(['index']);
            }
        } //пиздец помогите - это говно даже нейронка не понимает, ПАМАГИТИ Я В ТУПИКЕ АААААААААААААААААААААААААААААААААААААААААААААА
        return $this->render('rate', [
            'application' => $application,
            'rating' => $rating,
        ]);
    }

    public function actionCompleted()
    {
        $ratings = Rating::find()
            ->where(['expert_id' => Yii::$app->user->id, 'status' => 'completed'])
            ->orderBy(['updated_at' => SORT_DESC])
            ->all();

        return $this->render('completed', [
            'ratings' => $ratings,
        ]);
    }
}